/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于快速走点
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.3.17
 *      内容 : 所有代码
 *************************************************************************************************/
/* exported mc_point_finishing_point_by_step */
/* global  mc_sdk_param*/
/* global  mc_pixtrace_scan_pix_data*/

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据跳点值,整理已知走点
 * 参数:
 *    @param {Promise<Array>} param_data 已知走点信息
 *    @param {Promise<String>} str_info_json 注冊信息
 * 返回：
 *   @returns {Promise<Array>} 真实点数下标
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.6.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_point_finishing_point_by_step(param_data,str_info_json) {
    var obj_info_msg = new mc_sdk_param();

    if (!obj_info_msg.set_json(str_info_json)) {
        return param_data;
    }
    //跳点值
    var ui_step_val = 2;
    // var ui_step_val = Number(obj_info_msg.get_param_val("IC_CHANNELS"));


    var ary_point_val = [];

    for (var idx_str = 0; idx_str < param_data.length; idx_str++) {
        var ary_str_val = param_data[idx_str];
        var obj_point_val = new mc_pixtrace_scan_pix_data();

        for (var idx_point = 0; idx_point < ary_str_val.length; idx_point++) {
            obj_point_val.set_walk_point(ary_str_val[idx_point],"R");
        }
        ary_str_val = obj_point_val.get_led_data_by_step(ui_step_val);

        if (!ary_str_val) {
            parent.mc_alert_popout( "MC_HINT_MODULE_POINT_LENGHT_ERROR");
            return false;
        }
        for (var idx_scan = 0; idx_scan < ary_str_val.length; idx_scan++) {
            var ary_scan = ary_str_val[idx_scan];

            for (var idx_pix = 0; idx_pix < ary_scan.length; idx_pix++) {
                var obj_point = ary_scan[idx_pix];

                ary_point_val.push({
                    x: obj_point.x,
                    y: obj_point.y,
                    idx: obj_point.idx,
                    invalid_cnt: obj_point.invalid_cnt,
                    sweep: obj_point.sweep
                });
            }
        }
    }
    return ary_point_val;
}


